#!/bin/bash

# CUDA_VISIBLE_DEVICES=7 nohup python run_AlphaEdit_editing.py \
#     --editing_method=AlphaEdit \
#     --hparams_dir=../hparams/AlphaEdit/llama-7b.yaml \
#     --data_dir=../data/ZsRE \
#     --ds_size=1000 \
#     --data_type=ZsRE \
#     --sequential_edit > run_alphaedit.log 2>&1 &

#!/bin/bash
 
editing_method="WISE"
# hparams_dir="../hparams/PMET/llama3-8b-instruct.yaml"

hparams_dir="../hparams/WISE/llama3-8b-instruct.yaml"
# data_dir="../data/ZsRE" 
# ds_size=100
# data_type="ZsRE" 

data_dir="../data/CF"
ds_size=2000
data_type="CF" 

type="base-2k"     
# type="na_0-1_mask-0.9_postmask"                                             # na_0-1_mask-0.2_postmask
# type="na_0-1_mask_postmask_resonance_ratio=0.2_burst_ratio=0.1"  
# type="na_0-1_mask_postmask_resonance_entropy_adaptive_mask_ratio_0.3-0.4_0.2-0.3"             # na_0-1_mask_postmask_resonance_ratio=0.3_burst_ratio=0.1
 
hparams_base=$(basename "$hparams_dir" .yaml)
 
log_file="run_${editing_method}_${hparams_base}_${ds_size}_${data_type}_${type}.log"
 
echo "Log file: ${log_file}"
 
CUDA_VISIBLE_DEVICES=0 nohup python run_gen_editing.py \
    --editing_method=${editing_method} \
    --hparams_dir=${hparams_dir} \
    --data_dir=${data_dir} \
    --ds_size=${ds_size} \
    --data_type=${data_type} \
    --sequential_edit > ${log_file} 2>&1 &


